/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NovaExplosion
extends Explosion {
    private final Level level;
    private final Explosion.BlockInteraction mode;
    private final double x;
    private final double y;
    private final double z;
    private final float size;

    public NovaExplosion(Level level, @Nullable Entity entity, double x, double y, double z, float radius, boolean causesFire, Explosion.BlockInteraction mode) {
        super(level, entity, null, null, x, y, z, radius, causesFire, mode);
        this.level = level;
        this.mode = mode;
        this.size = radius;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void m_46075_(boolean spawnParticles) {
        boolean hasExplosionMode;
        if (this.level.f_46443_) {
            this.level.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.f_46441_.nextFloat() - this.level.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = hasExplosionMode = this.mode != Explosion.BlockInteraction.NONE;
        if (spawnParticles) {
            if (hasExplosionMode && this.size >= 2.0f) {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (hasExplosionMode) {
            NonNullList allDrops = NonNullList.m_122779_();
            List affectedBlockPositions = this.m_46081_();
            Collections.shuffle(affectedBlockPositions, this.level.f_46441_);
            for (BlockPos pos : affectedBlockPositions) {
                BlockState state = this.level.m_8055_(pos);
                if (state.m_60795_()) continue;
                if (spawnParticles) {
                    double adjustedX = (float)pos.m_123341_() + this.level.f_46441_.nextFloat();
                    double adjustedY = (float)pos.m_123342_() + this.level.f_46441_.nextFloat();
                    double adjustedZ = (float)pos.m_123343_() + this.level.f_46441_.nextFloat();
                    double diffX = adjustedX - this.x;
                    double diffY = adjustedY - this.y;
                    double diffZ = adjustedZ - this.z;
                    double diff = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
                    diffX /= diff;
                    diffY /= diff;
                    diffZ /= diff;
                    double d7 = 0.5 / (diff / (double)this.size + 0.1);
                    this.level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (adjustedX + this.x) / 2.0, (adjustedY + this.y) / 2.0, (adjustedZ + this.z) / 2.0, diffX *= (d7 *= (double)(this.level.f_46441_.nextFloat() * this.level.f_46441_.nextFloat() + 0.3f)), diffY *= d7, diffZ *= d7);
                    this.level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, adjustedX, adjustedY, adjustedZ, diffX, diffY, diffZ);
                }
                pos = pos.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                Level level = this.level;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (state.canDropFromExplosion((BlockGetter)this.level, pos, (Explosion)this)) {
                        BlockEntity blockEntity = state.m_155947_() ? WorldHelper.getBlockEntity((BlockGetter)serverLevel, pos) : null;
                        LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78977_(serverLevel.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockEntity).m_78984_(LootContextParams.f_81455_, (Object)this.getExploder());
                        if (this.mode == Explosion.BlockInteraction.DESTROY) {
                            builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.size));
                        }
                        allDrops.addAll((Collection)state.m_60724_(builder));
                    }
                }
                state.onBlockExploded(this.level, pos, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
            LivingEntity placer = this.m_46079_();
            if (placer == null) {
                WorldHelper.createLootDrop((List<ItemStack>)allDrops, this.level, this.x, this.y, this.z);
            } else {
                WorldHelper.createLootDrop((List<ItemStack>)allDrops, this.level, placer.m_142538_());
            }
        }
    }
}

